/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Font3D;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.ScaledFont3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.Label3DDrawable;
import com.roguewave.chart.standard.v2_1.parts.LabelGenerator;
import java.awt.Color;

class LabelGenerator3D
implements LabelGenerator {
    static final double xScale = 0.75;
    static final Transform3D scaleX = Transform3D.scale(0.75, 1.0, 1.0);
    static final Font3D font3D = new Font3D();
    static final double pad = 0.1;
    double fontHeight_;
    ScaledFont3D font_;
    double maxWidth_ = 0.0;

    public LabelGenerator3D(double fontHeight) {
        this.fontHeight_ = fontHeight;
        this.font_ = new ScaledFont3D(font3D, this.fontHeight_, true);
    }

    public LabelGenerator3D(double fontHeight, double maxWidth) {
        this.fontHeight_ = fontHeight;
        this.font_ = new ScaledFont3D(font3D, this.fontHeight_, true);
        this.maxWidth_ = maxWidth;
    }

    public Drawable getLabel(String label, Point3D origin, int alignment, Color color) {
        double yShift;
        double xShift;
        double unscaledWidth = this.font_.stringWidth(label);
        double width = unscaledWidth * 0.75;
        Transform3D strans = scaleX;
        if (this.maxWidth_ > 0.0 && width > this.maxWidth_) {
            double scale = 1.0 / width * 0.75 * this.maxWidth_;
            strans = Transform3D.scale(scale, 1.0, 1.0);
            width = unscaledWidth * scale;
        }
        switch (alignment) {
            case 1: {
                xShift = -(width + 0.1);
                yShift = -this.fontHeight_ / (double)3;
                break;
            }
            case 2: {
                xShift = 0.1;
                yShift = -this.fontHeight_ / (double)3;
                break;
            }
            case 0: {
                xShift = -width / (double)2;
                yShift = -(0.1 + this.fontHeight_);
                break;
            }
            default: {
                yShift = 0.0;
                xShift = 0.0;
            }
        }
        Point3D shifted = origin.plus(new Point3D(xShift, yShift, 0.0));
        return new Label3DDrawable(this.font_.stringLines(label, shifted, strans), color);
    }
}

